﻿{$reference ExtendedNumerics.BigDecimal.dll}
uses ExtendedNumerics;
uses MathExtensions;
         

procedure Solve2;
begin   
   BigDecimal.Precision := 6;
   var n1 := BigDecimal(1);
   var n2 := BigDecimal(7);
   var n3 := (n1 / n2);
   Writeln(' ' + n3);
   Writeln;  
   
   BigDecimal.Precision := 15;
   n1 := BigDecimal(1);
   n2 := BigDecimal(17);
   n3 := (n1 / n2);
   Writeln(' ' + n3);
   Writeln;  
end;


function Test(snum: string): bool;
begin   
   // число:
   var num := BigInteger.Parse(snum);
   // длина числа:
   var numlen := snum.Length;
   println($' Длина цикла = {numlen}');
   // цикл:
   var cycle := snum * 2;
   println($' Цикл: {cycle}');

   // проверяем произведения:
   foreach var i in range(2, numlen) do begin
      var mult := num * i;
      var smult := mult.ToString;
      // не циклическое число:
      if smult not in cycle then exit(False);
   end;
   // циклическое число:
   Result := True;     
end;

procedure Solve3;
begin   
   var snum := '142857';
   snum := '0588235294117647';
   snum := '016393442622950819672131147540983606557377049180327868852459'; 
   snum := '010309278350515463917525773195876288659793814432989690721649484536082474226804123711340206185567';   
   snum := '0010172939979654120040691759918616480162767039674465920651068158697863682604272634791454730417090539165818921668362156663275686673448626653102746693794506612410986775178026449643947100712105798575788402848423194303153611393692777212614445574771108850457782299084435401831129196337741607324516785350966429298067141403865717192268565615462868769074262461851475076297049847405900305188199389623601220752797558494404883011190233977619532044760935910478128179043743641912512716174974567650050864699898270600203458799593082400813835198372329603255340793489318413021363173957273652085452695829094608341810783316378433367243133265513733468972533062054933875890132248219735503560528992878942014242115971515768056968463886063072227873855544252288911495422177009155645981688708036622583926754832146490335707019328585961342828077314343845371312309257375381485249237029501525940996948118006103763987792472024415055951169888097660223804679552390640895218718209562563580874872838250254323499491353';   
   var res := Test(snum);
   if (res) then
       println($' Число {snum} - циклическое')
   else
       println(' Число {snum} - не циклическое');
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin   
   var n := 142857;
   foreach var i in range(1,6) do
      Println($' {i} * {n} = {n * i}');
   Writeln;   
   
   var m: int64 := 588235294117647;
   foreach var i in range(1,16) do
      Println($' {i} * {m} = {m * i}');
   Writeln;   
end;


begin
   Writeln(' Циклические числа');
   Writeln;
       
   //Solve;
   //Solve2;  
   Solve3;   
end.
